/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.command;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import cz.insophy.inplan.command.UndoableCommand;
import cz.insophy.inplan.planning.algorithms.RebuildPlannerUtils;
import cz.insophy.inplan.planning.mokos.MaterialBoundUpdater;
import cz.insophy.inplan.planning.mokos.MokosRunner;
import cz.insophy.inplan.planning.mokos.Scheduler;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Formatter;
import cz.insophy.inplan.util.Localizer;
import cz.insophy.inplan.util.problems.Problem;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateVirtualGorCommand
implements UndoableCommand {
    private static final Logger log = LoggerFactory.getLogger(CreateVirtualGorCommand.class);
    private static final long serialVersionUID = 1L;
    private static final String VIRTUAL_ID_PREFIX = "V";
    private String productName;
    private String actiongramName;
    private double qty;
    private long releaseDate;
    private long dueDate;
    private String destStoreId;
    private boolean doPlanning = true;
    private String generatedGorId;
    private String currentResult = "";
    private String lastResult = "";

    @Override
    public String getDescription() {
        Object description = Localizer.getString("command.cvg.desc", this.generatedGorId, this.productName, this.qty, new Date(this.dueDate));
        if (this.currentResult != null && !this.currentResult.isEmpty()) {
            description = (String)description + " - " + Localizer.getString("command.cvg.result_current", this.currentResult);
        }
        if (this.lastResult != null && !this.lastResult.isEmpty()) {
            description = (String)description + " - " + Localizer.getString("command.cvg.result_last", this.lastResult);
        }
        return description;
    }

    @Override
    public List<Problem> execute(Superplan superplan) {
        Preconditions.checkNotNull(superplan);
        List<Problem> problems = Problem.createList();
        if (this.createGor(superplan, problems) && this.doPlanning) {
            this.planGor(superplan, problems);
        }
        this.lastResult = this.currentResult;
        this.currentResult = this.getResult(superplan);
        return problems;
    }

    private String getResult(Superplan superplan) {
        GeneralizedOrderRequest gor = superplan.getGor(this.generatedGorId);
        if (gor != null && GeneralizedRequest.isDateValid(gor.getEndDate())) {
            return Formatter.formatShortDateTime(gor.getEndDate());
        }
        return Localizer.getString("command.cvg.result_no_date");
    }

    private boolean createGor(Superplan superplan, List<Problem> problems) {
        String virtualId;
        ShopConfiguration conf = superplan.getShopConf();
        Random rand = new Random();
        while (superplan.getGor(virtualId = String.format("%s%05d", VIRTUAL_ID_PREFIX, rand.nextInt(99999) + 1)) != null) {
        }
        Product product = conf.getProduct(this.productName);
        if (product == null) {
            problems.add(Problem.createProblem2("03900", this.productName));
            return false;
        }
        Actiongram actiongram = product.getActiongram(this.actiongramName);
        if (actiongram == null) {
            problems.add(Problem.createProblem2("03925", this.actiongramName, this.productName));
            return false;
        }
        GeneralizedOrderRequest virtualGor = new GeneralizedOrderRequest(virtualId, product, this.qty, this.releaseDate, this.dueDate, GeneralizedOrderRequest.State.VIRTUAL);
        virtualGor.setActiongram(actiongram);
        superplan.addGor(virtualGor);
        this.generatedGorId = virtualId;
        log.info("Created and added gor {}", (Object)this.generatedGorId);
        return true;
    }

    private void planGor(Superplan superplan, List<Problem> problems) {
        ArrayList<GeneralizedOrderRequest> origSelection = Lists.newArrayList();
        for (GeneralizedOrderRequest gor : superplan.getGors()) {
            if (gor.isUserSelected()) {
                origSelection.add(gor);
            }
            gor.setUserSelected(false);
        }
        GeneralizedOrderRequest gor = superplan.getGor(this.generatedGorId);
        gor.setUserSelected(true);
        try {
            MokosRunner runner = new MokosRunner();
            runner.setSuperplan(superplan);
            ((Scheduler)runner.getPlanningAlgorithm()).getProcessors(MaterialBoundUpdater.class).forEach(mbu -> mbu.setMatHorizonTreatment(StoreSchedule.MatHorizonTreatment.NO_HORIZONS));
            runner.run();
        }
        catch (Exception e) {
            problems.add(Problem.createProblem2("03950", this.generatedGorId, e.getLocalizedMessage()));
        }
        if (gor.getAmount() > 1.0E-7) {
            problems.add(Problem.createProblem2("04000", this.generatedGorId));
            superplan.removeGor(gor);
            RebuildPlannerUtils.fixAndRegister(superplan.getPlan());
            log.info("Unplanned gor {} removed from superplan.", (Object)this.generatedGorId);
        } else {
            log.info("Planned gor {}", (Object)this.generatedGorId);
        }
        gor.setUserSelected(false);
        for (GeneralizedOrderRequest selGor : origSelection) {
            selGor.setUserSelected(true);
        }
    }

    @Override
    public List<Problem> unexecute(Superplan superplan) {
        Preconditions.checkNotNull(superplan);
        Preconditions.checkState(this.generatedGorId != null);
        ArrayList<Problem> problems = Lists.newArrayList();
        GeneralizedOrderRequest gor = superplan.getGor(this.generatedGorId);
        if (gor != null) {
            superplan.removeGor(gor);
            RebuildPlannerUtils.fixAndRegister(superplan.getPlan());
            log.info("Gor {} removed from superplan.", (Object)this.generatedGorId);
        } else {
            Problem prob = Problem.createProblem2("04050", this.generatedGorId);
            problems.add(prob);
            prob.logProblem(log);
        }
        return problems;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productId) {
        this.productName = productId;
    }

    public String getActiongramName() {
        return this.actiongramName;
    }

    public void setActiongramName(String actiongramName) {
        this.actiongramName = actiongramName;
    }

    public double getQty() {
        return this.qty;
    }

    public void setQty(double qty) {
        this.qty = qty;
    }

    public long getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(long releaseDate) {
        this.releaseDate = releaseDate;
    }

    public long getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(long dueDate) {
        this.dueDate = dueDate;
    }

    public String getDestStoreId() {
        return this.destStoreId;
    }

    public void setDestStoreId(String destStoreId) {
        this.destStoreId = destStoreId;
    }

    public boolean isDoPlanning() {
        return this.doPlanning;
    }

    public void setDoPlanning(boolean doPlanning) {
        this.doPlanning = doPlanning;
    }

    public String getGeneratedGorId() {
        return this.generatedGorId;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("destStoreId", this.destStoreId).add("generatedGorId", this.generatedGorId).add("doPlanning", this.doPlanning).add("dueDate", this.dueDate).add("productName", this.productName).add("qty", this.qty).add("releaseDate", this.releaseDate).toString();
    }
}

